/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.CRC32MismatchException;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.JsonUnmarshallerContextImpl;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.transform.VoidJsonUnmarshaller;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.ValidationUtils;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public class JsonResponseHandler<T>
implements HttpResponseHandler<AmazonWebServiceResponse<T>> {
    private Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller;
    private static final Log log = LogFactory.getLog("com.amazonaws.request");
    private final JsonFactory jsonFactory;
    private final boolean needsConnectionLeftOpen;
    private final boolean isPayloadJson;
    private final Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> simpleTypeUnmarshallers;
    private final Map<JsonUnmarshallerContext.UnmarshallerType, Unmarshaller<?, JsonUnmarshallerContext>> customTypeMarshallers;

    public JsonResponseHandler(Unmarshaller<T, JsonUnmarshallerContext> voidJsonUnmarshaller, Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> map, Map<JsonUnmarshallerContext.UnmarshallerType, Unmarshaller<?, JsonUnmarshallerContext>> map2, JsonFactory jsonFactory, boolean bl, boolean bl2) {
        this.responseUnmarshaller = voidJsonUnmarshaller != null ? voidJsonUnmarshaller : new VoidJsonUnmarshaller();
        this.needsConnectionLeftOpen = bl;
        this.isPayloadJson = bl2;
        this.simpleTypeUnmarshallers = ValidationUtils.assertNotNull(map, "simple type unmarshallers");
        this.customTypeMarshallers = ValidationUtils.assertNotNull(map2, "custom type marshallers");
        this.jsonFactory = ValidationUtils.assertNotNull(jsonFactory, "JSONFactory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse httpResponse) throws Exception {
        log.trace("Parsing service response JSON");
        String string = httpResponse.getHeaders().get("x-amz-crc32");
        JsonParser jsonParser = null;
        if (this.shouldParsePayloadAsJson()) {
            jsonParser = this.jsonFactory.createParser(httpResponse.getContent());
        }
        try {
            AmazonWebServiceResponse<T> amazonWebServiceResponse = new AmazonWebServiceResponse<T>();
            JsonUnmarshallerContextImpl jsonUnmarshallerContextImpl = new JsonUnmarshallerContextImpl(jsonParser, this.simpleTypeUnmarshallers, this.customTypeMarshallers, httpResponse);
            this.registerAdditionalMetadataExpressions(jsonUnmarshallerContextImpl);
            T t2 = this.responseUnmarshaller.unmarshall(jsonUnmarshallerContextImpl);
            if (this.shouldParsePayloadAsJson() && httpResponse.getContent() != null) {
                IOUtils.drainInputStream(httpResponse.getContent());
            }
            if (string != null) {
                long l = Long.parseLong(string);
                long l2 = httpResponse.getCRC32Checksum();
                if (l2 != l) {
                    throw new CRC32MismatchException("Client calculated crc32 checksum didn't match that calculated by server side");
                }
            }
            amazonWebServiceResponse.setResult(t2);
            Map<String, String> map = ((JsonUnmarshallerContext)jsonUnmarshallerContextImpl).getMetadata();
            map.put("AWS_REQUEST_ID", httpResponse.getHeaders().get("x-amzn-RequestId"));
            amazonWebServiceResponse.setResponseMetadata(new ResponseMetadata(map));
            log.trace("Done parsing service response");
            AmazonWebServiceResponse<T> amazonWebServiceResponse2 = amazonWebServiceResponse;
            return amazonWebServiceResponse2;
        }
        finally {
            if (this.shouldParsePayloadAsJson()) {
                try {
                    jsonParser.close();
                }
                catch (IOException iOException) {
                    log.warn("Error closing json parser", iOException);
                }
            }
        }
    }

    protected void registerAdditionalMetadataExpressions(JsonUnmarshallerContext jsonUnmarshallerContext) {
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return this.needsConnectionLeftOpen;
    }

    private boolean shouldParsePayloadAsJson() {
        return !this.needsConnectionLeftOpen && this.isPayloadJson;
    }
}

