/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile.internal;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.auth.profile.internal.AbstractProfilesConfigFileScanner;
import com.amazonaws.auth.profile.internal.AllProfiles;
import com.amazonaws.auth.profile.internal.BasicProfile;
import com.amazonaws.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;

@SdkInternalApi
public class BasicProfileConfigLoader {
    public static final BasicProfileConfigLoader INSTANCE = new BasicProfileConfigLoader();

    private BasicProfileConfigLoader() {
    }

    public AllProfiles loadProfiles(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Unable to load AWS profiles: specified file is null.");
        }
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("AWS credential profiles file not found in the given path: " + file.getAbsolutePath());
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            AllProfiles allProfiles = this.loadProfiles(fileInputStream);
            return allProfiles;
        }
        catch (IOException iOException) {
            throw new SdkClientException("Unable to load AWS credential profiles file at: " + file.getAbsolutePath(), iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private AllProfiles loadProfiles(InputStream inputStream2) throws IOException {
        ProfilesConfigFileLoaderHelper profilesConfigFileLoaderHelper = new ProfilesConfigFileLoaderHelper();
        Map<String, Map<String, String>> map = profilesConfigFileLoaderHelper.parseProfileProperties(new Scanner(inputStream2, StringUtils.UTF8.name()));
        LinkedHashMap<String, BasicProfile> linkedHashMap = new LinkedHashMap<String, BasicProfile>();
        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
            String string = entry.getKey();
            Map<String, String> map2 = entry.getValue();
            this.assertParameterNotEmpty(string, "Unable to load properties from profile: Profile name is empty.");
            linkedHashMap.put(string, new BasicProfile(string, map2));
        }
        return new AllProfiles(linkedHashMap);
    }

    private void assertParameterNotEmpty(String string, String string2) {
        if (StringUtils.isNullOrEmpty(string)) {
            throw new SdkClientException(string2);
        }
    }

    private static class ProfilesConfigFileLoaderHelper
    extends AbstractProfilesConfigFileScanner {
        protected final Map<String, Map<String, String>> allProfileProperties = new LinkedHashMap<String, Map<String, String>>();

        private ProfilesConfigFileLoaderHelper() {
        }

        public Map<String, Map<String, String>> parseProfileProperties(Scanner scanner) {
            this.allProfileProperties.clear();
            this.run(scanner);
            return new LinkedHashMap<String, Map<String, String>>(this.allProfileProperties);
        }

        @Override
        protected void onEmptyOrCommentLine(String string, String string2) {
        }

        @Override
        protected void onProfileStartingLine(String string, String string2) {
            this.allProfileProperties.put(string, new HashMap());
        }

        @Override
        protected void onProfileEndingLine(String string) {
        }

        @Override
        protected void onProfileProperty(String string, String string2, String string3, boolean bl, String string4) {
            Map<String, String> map = this.allProfileProperties.get(string);
            if (map.containsKey(string2)) {
                throw new IllegalArgumentException("Duplicate property values for [" + string2 + "].");
            }
            map.put(string2, string3);
        }

        @Override
        protected void onEndOfFile() {
        }
    }
}

