/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.auth.profile.internal.AbstractProfilesConfigFileScanner;
import com.amazonaws.auth.profile.internal.Profile;
import com.amazonaws.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProfilesConfigFileWriter {
    private static final Log LOG = LogFactory.getLog(ProfilesConfigFileWriter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpToFile(File file, boolean bl, Profile ... profileArray) {
        OutputStreamWriter outputStreamWriter;
        if (file.exists() && !bl) {
            throw new SdkClientException("The destination file already exists. Set overwrite=true if you want to clobber the existing content and completely re-write the file.");
        }
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), StringUtils.UTF8);
        }
        catch (IOException iOException) {
            throw new SdkClientException("Unable to open the destination file.", iOException);
        }
        try {
            LinkedHashMap<String, Profile> linkedHashMap = new LinkedHashMap<String, Profile>();
            for (Profile profile : profileArray) {
                linkedHashMap.put(profile.getProfileName(), profile);
            }
            ProfilesConfigFileWriterHelper profilesConfigFileWriterHelper = new ProfilesConfigFileWriterHelper(outputStreamWriter, linkedHashMap);
            profilesConfigFileWriterHelper.writeWithoutExistingContent();
        }
        finally {
            try {
                outputStreamWriter.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void modifyOrInsertProfiles(File file, Profile ... profileArray) {
        LinkedHashMap<String, Profile> linkedHashMap = new LinkedHashMap<String, Profile>();
        for (Profile profile : profileArray) {
            linkedHashMap.put(profile.getProfileName(), profile);
        }
        ProfilesConfigFileWriter.modifyProfiles(file, linkedHashMap);
    }

    public static void modifyOneProfile(File file, String string, Profile profile) {
        Map<String, Profile> map = Collections.singletonMap(string, profile);
        ProfilesConfigFileWriter.modifyProfiles(file, map);
    }

    public static void deleteProfiles(File file, String ... stringArray) {
        LinkedHashMap<String, Profile> linkedHashMap = new LinkedHashMap<String, Profile>();
        for (String string : stringArray) {
            linkedHashMap.put(string, null);
        }
        ProfilesConfigFileWriter.modifyProfiles(file, linkedHashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void modifyProfiles(File file, Map<String, Profile> map) {
        boolean bl = file.exists();
        File file2 = null;
        if (bl) {
            boolean bl2 = false;
            try {
                file2 = new File(file.getParentFile(), file.getName() + ".bak." + UUID.randomUUID().toString());
                bl2 = file.renameTo(file2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("The original credentials file is stashed to location (%s).", file2.getAbsolutePath()));
                }
            }
            finally {
                if (!bl2) {
                    throw new SdkClientException("Failed to stash the existing credentials file before applying the changes.");
                }
            }
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StringUtils.UTF8);
            ProfilesConfigFileWriterHelper profilesConfigFileWriterHelper = new ProfilesConfigFileWriterHelper(outputStreamWriter, map);
            if (bl) {
                Scanner scanner = new Scanner(file2, StringUtils.UTF8.name());
                profilesConfigFileWriterHelper.writeWithExistingContent(scanner);
            } else {
                profilesConfigFileWriterHelper.writeWithoutExistingContent();
            }
            new ProfilesConfigFile(file);
            if (bl && !file2.delete() && LOG.isDebugEnabled()) {
                LOG.debug(String.format("Successfully modified the credentials file. But failed to delete the stashed copy of the original file (%s).", file2.getAbsolutePath()));
            }
        }
        catch (Exception exception) {
            if (bl) {
                boolean bl3 = false;
                try {
                    if (!file.delete()) {
                        LOG.debug("Unable to remove the credentials file before restoring the original one.");
                    }
                    bl3 = file2.renameTo(file);
                }
                finally {
                    if (!bl3) {
                        throw new SdkClientException("Unable to restore the original credentials file. File content stashed in " + file2.getAbsolutePath());
                    }
                }
            }
            throw new SdkClientException("Unable to modify the credentials file. (The original file has been restored.)", exception);
        }
        finally {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static class ProfilesConfigFileWriterHelper
    extends AbstractProfilesConfigFileScanner {
        private final Writer writer;
        private final Map<String, Profile> newProfiles = new LinkedHashMap<String, Profile>();
        private final Set<String> deletedProfiles = new HashSet<String>();
        private final StringBuilder buffer = new StringBuilder();
        private final Map<String, Set<String>> existingProfileProperties = new HashMap<String, Set<String>>();

        public ProfilesConfigFileWriterHelper(Writer writer, Map<String, Profile> map) {
            this.writer = writer;
            for (Map.Entry<String, Profile> entry : map.entrySet()) {
                String string = entry.getKey();
                Profile profile = entry.getValue();
                if (profile == null) {
                    this.deletedProfiles.add(string);
                    continue;
                }
                this.newProfiles.put(string, profile);
            }
        }

        public void writeWithoutExistingContent() {
            this.buffer.setLength(0);
            this.existingProfileProperties.clear();
            this.run(new Scanner(""));
        }

        public void writeWithExistingContent(Scanner scanner) {
            this.buffer.setLength(0);
            this.existingProfileProperties.clear();
            this.run(scanner);
        }

        @Override
        protected void onEmptyOrCommentLine(String string, String string2) {
            if (string == null || !this.deletedProfiles.contains(string)) {
                this.buffer(string2);
            }
        }

        @Override
        protected void onProfileStartingLine(String string, String string2) {
            String string3;
            this.existingProfileProperties.put(string, new HashSet());
            this.flush();
            if (this.deletedProfiles.contains(string)) {
                return;
            }
            if (this.newProfiles.get(string) != null && !(string3 = this.newProfiles.get(string).getProfileName()).equals(string)) {
                string2 = "[" + string3 + "]";
            }
            this.writeLine(string2);
        }

        @Override
        protected void onProfileEndingLine(String string) {
            Profile profile = this.newProfiles.get(string);
            if (profile != null) {
                for (Map.Entry<String, String> entry : profile.getProperties().entrySet()) {
                    String string2 = entry.getKey();
                    String string3 = entry.getValue();
                    if (this.existingProfileProperties.get(string).contains(string2)) continue;
                    this.writeProperty(string2, string3);
                }
            }
            this.flush();
        }

        @Override
        protected void onProfileProperty(String string, String string2, String string3, boolean bl, String string4) {
            if (this.existingProfileProperties.get(string) == null) {
                this.existingProfileProperties.put(string, new HashSet());
            }
            this.existingProfileProperties.get(string).add(string2);
            if (this.deletedProfiles.contains(string)) {
                return;
            }
            if (!bl) {
                this.writeLine(string4);
                return;
            }
            this.flush();
            if (this.newProfiles.containsKey(string)) {
                String string5 = this.newProfiles.get(string).getPropertyValue(string2);
                if (string5 != null) {
                    this.writeProperty(string2, string5);
                }
            } else {
                this.writeLine(string4);
            }
        }

        @Override
        protected void onEndOfFile() {
            for (Map.Entry<String, Profile> entry : this.newProfiles.entrySet()) {
                String string = entry.getKey();
                Profile profile = entry.getValue();
                if (this.existingProfileProperties.containsKey(string)) continue;
                this.writeProfile(profile);
                this.writeLine("");
            }
            try {
                this.writer.flush();
            }
            catch (IOException iOException) {
                throw new SdkClientException("Unable to write to the target file to persist the profile credentials.", iOException);
            }
        }

        @Override
        protected boolean isSupportedProperty(String string) {
            return "aws_access_key_id".equals(string) || "aws_secret_access_key".equals(string) || "aws_session_token".equals(string) || "external_id".equals(string) || "role_arn".equals(string) || "role_session_name".equals(string) || "source_profile".equals(string);
        }

        private void writeProfile(Profile profile) {
            this.writeProfileName(profile.getProfileName());
            for (Map.Entry<String, String> entry : profile.getProperties().entrySet()) {
                this.writeProperty(entry.getKey(), entry.getValue());
            }
        }

        private void writeProfileName(String string) {
            this.writeLine(String.format("[%s]", string));
        }

        private void writeProperty(String string, String string2) {
            this.writeLine(String.format("%s=%s", string, string2));
        }

        private void writeLine(String string) {
            this.append(String.format("%s%n", string));
        }

        private void append(String string) {
            try {
                this.writer.append(string);
            }
            catch (IOException iOException) {
                throw new SdkClientException("Unable to write to the target file to persist the profile credentials.", iOException);
            }
        }

        private void flush() {
            if (this.buffer.length() != 0) {
                this.append(this.buffer.toString());
                this.buffer.setLength(0);
            }
        }

        private void buffer(String string) {
            this.buffer.append(String.format("%s%n", string));
        }
    }
}

