/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.auth.profile.internal.AwsProfileNameLoader;
import java.util.concurrent.Semaphore;

public class ProfileCredentialsProvider
implements AWSCredentialsProvider {
    private static final long DEFAULT_REFRESH_INTERVAL_NANOS = 300000000000L;
    private static final long DEFAULT_FORCE_RELOAD_INTERVAL_NANOS = 600000000000L;
    private volatile ProfilesConfigFile profilesConfigFile;
    private volatile long lastRefreshed;
    private final String profileName;
    private final Semaphore refreshSemaphore = new Semaphore(1);
    private long refreshIntervalNanos = 300000000000L;
    private long refreshForceIntervalNanos = 600000000000L;

    public ProfileCredentialsProvider() {
        this(null);
    }

    public ProfileCredentialsProvider(String string) {
        this((ProfilesConfigFile)null, string);
    }

    public ProfileCredentialsProvider(String string, String string2) {
        this(new ProfilesConfigFile(string), string2);
    }

    public ProfileCredentialsProvider(ProfilesConfigFile profilesConfigFile, String string) {
        this.profilesConfigFile = profilesConfigFile;
        if (this.profilesConfigFile != null) {
            this.lastRefreshed = System.nanoTime();
        }
        this.profileName = string == null ? AwsProfileNameLoader.INSTANCE.loadProfileName() : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AWSCredentials getCredentials() {
        long l;
        long l2;
        if (this.profilesConfigFile == null) {
            ProfileCredentialsProvider profileCredentialsProvider = this;
            synchronized (profileCredentialsProvider) {
                if (this.profilesConfigFile == null) {
                    this.profilesConfigFile = new ProfilesConfigFile();
                    this.lastRefreshed = System.nanoTime();
                }
            }
        }
        if ((l2 = (l = System.nanoTime()) - this.lastRefreshed) > this.refreshForceIntervalNanos) {
            this.refresh();
        } else if (l2 > this.refreshIntervalNanos && this.refreshSemaphore.tryAcquire()) {
            try {
                this.refresh();
            }
            finally {
                this.refreshSemaphore.release();
            }
        }
        return this.profilesConfigFile.getCredentials(this.profileName);
    }

    @Override
    public void refresh() {
        if (this.profilesConfigFile != null) {
            this.profilesConfigFile.refresh();
            this.lastRefreshed = System.nanoTime();
        }
    }

    public long getRefreshIntervalNanos() {
        return this.refreshIntervalNanos;
    }

    public void setRefreshIntervalNanos(long l) {
        this.refreshIntervalNanos = l;
    }

    public long getRefreshForceIntervalNanos() {
        return this.refreshForceIntervalNanos;
    }

    public void setRefreshForceIntervalNanos(long l) {
        this.refreshForceIntervalNanos = l;
    }
}

