/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.internal;

import com.amazonaws.annotation.Immutable;

@Immutable
public final class SignerKey {
    private final long numberOfDaysSinceEpoch;
    private final byte[] signingKey;

    public SignerKey(long l, byte[] byArray) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Not able to cache signing key. Signing date to be cached is invalid");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Not able to cache signing key. Signing Key to be cached are null");
        }
        this.numberOfDaysSinceEpoch = l;
        this.signingKey = (byte[])byArray.clone();
    }

    public long getNumberOfDaysSinceEpoch() {
        return this.numberOfDaysSinceEpoch;
    }

    public byte[] getSigningKey() {
        return (byte[])this.signingKey.clone();
    }
}

