/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.internal;

import com.amazonaws.SignableRequest;
import com.amazonaws.auth.SdkClock;
import com.amazonaws.auth.internal.AWS4SignerUtils;
import com.amazonaws.util.endpoint.DefaultRegionFromEndpointResolver;
import com.amazonaws.util.endpoint.RegionFromEndpointResolver;
import java.util.Date;

public final class AWS4SignerRequestParams {
    private final SignableRequest<?> request;
    private final long signingDateTimeMilli;
    private final String scope;
    private final String regionName;
    private final String serviceName;
    private final String formattedSigningDateTime;
    private final String formattedSigningDate;
    private final String signingAlgorithm;

    public AWS4SignerRequestParams(SignableRequest<?> signableRequest, Date date, String string, String string2, String string3) {
        this(signableRequest, date, string, string2, string3, null);
    }

    public AWS4SignerRequestParams(SignableRequest<?> signableRequest, Date date, String string, String string2, String string3, String string4) {
        this(signableRequest, date, string, string2, string3, string4, null);
    }

    public AWS4SignerRequestParams(SignableRequest<?> signableRequest, Date date, String string, String string2, String string3, String string4, RegionFromEndpointResolver regionFromEndpointResolver) {
        if (signableRequest == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("Signing Algorithm cannot be null");
        }
        this.request = signableRequest;
        this.signingDateTimeMilli = date != null ? date.getTime() : this.getSigningDate(signableRequest);
        this.formattedSigningDate = AWS4SignerUtils.formatDateStamp(this.signingDateTimeMilli);
        this.serviceName = string2;
        this.regionName = string != null ? string : this.resolveRegion(regionFromEndpointResolver, string4, this.serviceName);
        this.scope = this.generateScope(signableRequest, this.formattedSigningDate, this.serviceName, this.regionName);
        this.formattedSigningDateTime = AWS4SignerUtils.formatTimestamp(this.signingDateTimeMilli);
        this.signingAlgorithm = string3;
    }

    private String resolveRegion(RegionFromEndpointResolver regionFromEndpointResolver, String string, String string2) {
        if (regionFromEndpointResolver == null) {
            regionFromEndpointResolver = new DefaultRegionFromEndpointResolver();
        }
        String string3 = this.request.getEndpoint().getHost();
        String string4 = regionFromEndpointResolver.guessRegionFromEndpoint(string3, string != null ? string : string2);
        return string4 != null ? string4 : "us-east-1";
    }

    private final long getSigningDate(SignableRequest<?> signableRequest) {
        return SdkClock.Instance.get().currentTimeMillis() - (long)signableRequest.getTimeOffset() * 1000L;
    }

    private String generateScope(SignableRequest<?> signableRequest, String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append(string).append("/").append(string3).append("/").append(string2).append("/").append("aws4_request").toString();
    }

    public SignableRequest<?> getRequest() {
        return this.request;
    }

    public String getScope() {
        return this.scope;
    }

    public String getFormattedSigningDateTime() {
        return this.formattedSigningDateTime;
    }

    public long getSigningDateTimeMilli() {
        return this.signingDateTimeMilli;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getFormattedSigningDate() {
        return this.formattedSigningDate;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }
}

