/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
abstract class BaseCredentialsFetcher {
    private static final Log LOG = LogFactory.getLog(BaseCredentialsFetcher.class);
    private static final int REFRESH_THRESHOLD = 3600000;
    private static final int FIFTEEN_MINUTES_IN_MILLIS = 900000;
    private static final int EXPIRATION_THRESHOLD = 900000;
    private static final String ACCESS_KEY_ID = "AccessKeyId";
    private static final String SECRET_ACCESS_KEY = "SecretAccessKey";
    private static final String TOKEN = "Token";
    private final boolean allowExpiredCredentials;
    private volatile AWSCredentials credentials;
    private volatile Date credentialsExpiration;
    protected volatile Date lastInstanceProfileCheck;

    protected BaseCredentialsFetcher(boolean bl) {
        this.allowExpiredCredentials = bl;
    }

    public AWSCredentials getCredentials() {
        if (this.needsToLoadCredentials()) {
            this.fetchCredentials();
        }
        if (this.expired()) {
            throw new SdkClientException("The credentials received have been expired");
        }
        return this.credentials;
    }

    boolean needsToLoadCredentials() {
        if (this.credentials == null) {
            return true;
        }
        if (this.credentialsExpiration != null && this.isWithinExpirationThreshold()) {
            return true;
        }
        return this.lastInstanceProfileCheck != null && this.isPastRefreshThreshold();
    }

    abstract String getCredentialsResponse();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void fetchCredentials() {
        if (!this.needsToLoadCredentials()) {
            return;
        }
        try {
            this.lastInstanceProfileCheck = new Date();
            String string = this.getCredentialsResponse();
            JsonNode jsonNode = Jackson.fromSensitiveJsonString(string, JsonNode.class);
            JsonNode jsonNode2 = jsonNode.get(ACCESS_KEY_ID);
            JsonNode jsonNode3 = jsonNode.get(SECRET_ACCESS_KEY);
            JsonNode jsonNode4 = jsonNode.get(TOKEN);
            if (null == jsonNode2 || null == jsonNode3) {
                throw new SdkClientException("Unable to load credentials. Access key or secret key are null.");
            }
            this.credentials = null != jsonNode4 ? new BasicSessionCredentials(jsonNode2.asText(), jsonNode3.asText(), jsonNode4.asText()) : new BasicAWSCredentials(jsonNode2.asText(), jsonNode3.asText());
            JsonNode jsonNode5 = jsonNode.get("Expiration");
            if (null != jsonNode5) {
                String string2 = jsonNode5.asText();
                string2 = string2.replaceAll("\\+0000$", "Z");
                try {
                    this.credentialsExpiration = DateUtils.parseISO8601Date(string2);
                }
                catch (Exception exception) {
                    this.handleError("Unable to parse credentials expiration date from Amazon EC2 instance", exception);
                }
            }
        }
        catch (Exception exception) {
            this.handleError("Unable to load credentials from service endpoint", exception);
        }
        finally {
            if (this.allowExpiredCredentials && this.credentials != null && this.credentialsExpiration != null && this.needsToLoadCredentials()) {
                long l = System.currentTimeMillis();
                long l2 = this.credentialsExpiration.getTime() - 15000L;
                long l3 = l + 300000L;
                if (l2 > l) {
                    long l4 = l + 900000L;
                    long l5 = Math.min(l4, l2);
                    this.credentialsExpiration = new Date(l5 + 900000L);
                } else {
                    LOG.warn("Credential expiration has been extended due to a credential service availability issue. A refresh of these credentials will be attempted again in 5 minutes.");
                    this.credentialsExpiration = new Date(l3 + 900000L);
                }
            }
        }
    }

    private void handleError(String string, Exception exception) {
        if (this.credentials == null || this.expired()) {
            if (exception instanceof SdkClientException) {
                throw (SdkClientException)exception;
            }
            throw new SdkClientException(string, exception);
        }
        LOG.warn(string, exception);
    }

    public void refresh() {
        this.credentials = null;
    }

    private boolean isWithinExpirationThreshold() {
        return this.credentialsExpiration.getTime() - System.currentTimeMillis() < 900000L;
    }

    private boolean isPastRefreshThreshold() {
        return System.currentTimeMillis() - this.lastInstanceProfileCheck.getTime() > 3600000L;
    }

    private boolean expired() {
        if (this.allowExpiredCredentials) {
            return false;
        }
        if (this.credentialsExpiration == null) {
            return false;
        }
        return this.credentialsExpiration.getTime() <= System.currentTimeMillis();
    }

    Date getCredentialsExpiration() {
        return this.credentialsExpiration;
    }

    public String toString() {
        return "BaseCredentialsFetcher";
    }
}

