/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AWSCredentialsProviderChain
implements AWSCredentialsProvider {
    private static final Log log = LogFactory.getLog(AWSCredentialsProviderChain.class);
    private final List<AWSCredentialsProvider> credentialsProviders = new LinkedList<AWSCredentialsProvider>();
    private boolean reuseLastProvider = true;
    private AWSCredentialsProvider lastUsedProvider;

    public AWSCredentialsProviderChain(List<? extends AWSCredentialsProvider> list) {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("No credential providers specified");
        }
        this.credentialsProviders.addAll(list);
    }

    public AWSCredentialsProviderChain(AWSCredentialsProvider ... aWSCredentialsProviderArray) {
        if (aWSCredentialsProviderArray == null || aWSCredentialsProviderArray.length == 0) {
            throw new IllegalArgumentException("No credential providers specified");
        }
        for (AWSCredentialsProvider aWSCredentialsProvider : aWSCredentialsProviderArray) {
            this.credentialsProviders.add(aWSCredentialsProvider);
        }
    }

    public boolean getReuseLastProvider() {
        return this.reuseLastProvider;
    }

    public void setReuseLastProvider(boolean bl) {
        this.reuseLastProvider = bl;
    }

    @Override
    public AWSCredentials getCredentials() {
        if (this.reuseLastProvider && this.lastUsedProvider != null) {
            return this.lastUsedProvider.getCredentials();
        }
        LinkedList<String> linkedList = null;
        for (AWSCredentialsProvider aWSCredentialsProvider : this.credentialsProviders) {
            try {
                AWSCredentials aWSCredentials = aWSCredentialsProvider.getCredentials();
                if (aWSCredentials.getAWSAccessKeyId() == null || aWSCredentials.getAWSSecretKey() == null) continue;
                log.debug("Loading credentials from " + aWSCredentialsProvider.toString());
                this.lastUsedProvider = aWSCredentialsProvider;
                return aWSCredentials;
            }
            catch (Exception exception) {
                String string = aWSCredentialsProvider + ": " + exception.getMessage();
                log.debug("Unable to load credentials from " + string);
                if (linkedList == null) {
                    linkedList = new LinkedList<String>();
                }
                linkedList.add(string);
            }
        }
        throw new SdkClientException("Unable to load AWS credentials from any provider in the chain: " + linkedList);
    }

    @Override
    public void refresh() {
        for (AWSCredentialsProvider aWSCredentialsProvider : this.credentialsProviders) {
            aWSCredentialsProvider.refresh();
        }
    }
}

