/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.arn;

import com.amazonaws.util.ValidationUtils;

public class ArnResource {
    private final String resourceType;
    private final String resource;
    private final String qualifier;

    private ArnResource(Builder builder) {
        this.resourceType = builder.resourceType;
        this.resource = ValidationUtils.assertStringNotEmpty(builder.resource, "resource");
        this.qualifier = builder.qualifier;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResource() {
        return this.resource;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ArnResource fromString(String string) {
        char c;
        int n;
        Integer n2 = null;
        Integer n3 = null;
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (c != ':' && c != '/') continue;
            n2 = n;
            break;
        }
        if (n2 != null) {
            for (n = string.length() - 1; n > n2; --n) {
                c = string.charAt(n);
                if (c != ':') continue;
                n3 = n;
                break;
            }
        }
        if (n2 == null) {
            return ArnResource.builder().withResource(string).build();
        }
        if (n3 == null) {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1);
            return ArnResource.builder().withResourceType(string2).withResource(string3).build();
        }
        String string4 = string.substring(0, n2);
        String string5 = string.substring(n2 + 1, n3);
        String string6 = string.substring(n3 + 1);
        return ArnResource.builder().withResourceType(string4).withResource(string5).withQualifier(string6).build();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.resourceType != null) {
            stringBuilder.append(this.resourceType);
            stringBuilder.append(":");
        }
        stringBuilder.append(this.resource);
        if (this.qualifier != null) {
            stringBuilder.append(":");
            stringBuilder.append(this.qualifier);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ArnResource arnResource = (ArnResource)object;
        if (this.resourceType != null ? !this.resourceType.equals(arnResource.resourceType) : arnResource.resourceType != null) {
            return false;
        }
        if (!this.resource.equals(arnResource.resource)) {
            return false;
        }
        return this.qualifier != null ? this.qualifier.equals(arnResource.qualifier) : arnResource.qualifier == null;
    }

    public int hashCode() {
        int n = this.resourceType != null ? this.resourceType.hashCode() : 0;
        n = 31 * n + this.resource.hashCode();
        n = 31 * n + (this.qualifier != null ? this.qualifier.hashCode() : 0);
        return n;
    }

    public static final class Builder {
        private String resourceType;
        private String resource;
        private String qualifier;

        private Builder() {
        }

        public void setResourceType(String string) {
            this.resourceType = string;
        }

        public Builder withResourceType(String string) {
            this.setResourceType(string);
            return this;
        }

        public void setResource(String string) {
            this.resource = string;
        }

        public Builder withResource(String string) {
            this.setResource(string);
            return this;
        }

        public void setQualifier(String string) {
            this.qualifier = string;
        }

        public Builder withQualifier(String string) {
            this.setQualifier(string);
            return this;
        }

        public ArnResource build() {
            return new ArnResource(this);
        }
    }
}

