/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws;

import com.amazonaws.SdkClientException;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class AmazonServiceException
extends SdkClientException {
    private static final long serialVersionUID = 1L;
    private String requestId;
    private String errorCode;
    private ErrorType errorType = ErrorType.Unknown;
    private String errorMessage;
    private int statusCode;
    private String serviceName;
    private Map<String, String> httpHeaders;
    private byte[] rawResponse;
    private String proxyHost;

    public AmazonServiceException(String string) {
        super((String)null);
        this.errorMessage = string;
    }

    public AmazonServiceException(String string, Exception exception) {
        super(null, exception);
        this.errorMessage = string;
    }

    public void setRequestId(String string) {
        this.requestId = string;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setErrorCode(String string) {
        this.errorCode = string;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getMessage() {
        return this.getErrorMessage() + " (Service: " + this.getServiceName() + "; Status Code: " + this.getStatusCode() + "; Error Code: " + this.getErrorCode() + "; Request ID: " + this.getRequestId() + "; Proxy: " + this.getProxyHost() + ")";
    }

    public String getRawResponseContent() {
        return this.rawResponse == null ? null : new String(this.rawResponse, StringUtils.UTF8);
    }

    public void setRawResponseContent(String string) {
        this.rawResponse = string == null ? null : string.getBytes(StringUtils.UTF8);
    }

    public byte[] getRawResponse() {
        return this.rawResponse == null ? null : (byte[])this.rawResponse.clone();
    }

    public void setRawResponse(byte[] byArray) {
        this.rawResponse = byArray == null ? null : (byte[])byArray.clone();
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Map<String, String> map) {
        this.httpHeaders = map;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String string) {
        this.proxyHost = string;
    }

    public static enum ErrorType {
        Client,
        Service,
        Unknown;

    }
}

