/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.core.tools;

import com.uqm.crashsight.core.tools.UQMLog;

public class NDKHelper {
    private static boolean mIsLoadedSO = false;
    private static boolean mIsLoadingSO = false;
    private static final String coreSoName = "CrashSight";

    public static boolean loadSO() {
        if (!mIsLoadedSO && !mIsLoadingSO) {
            mIsLoadingSO = true;
            UQMLog.d("try to load CrashSight", new Object[0]);
            boolean bl = NDKHelper.loadPluginByReflection();
            if (bl) {
                mIsLoadedSO = true;
            } else {
                UQMLog.d("CrashSight loading failed.", new Object[0]);
            }
        } else {
            UQMLog.d("CrashSight have been loaded", new Object[0]);
        }
        mIsLoadingSO = false;
        return mIsLoadedSO;
    }

    public static boolean checkSOLoaded() {
        if (!mIsLoadedSO && mIsLoadingSO) {
            UQMLog.e("--------------------------------------------\n.so has not been loaded. To use JNI helper, please initialize with \nUQMPlatform.initialize (Activity activity);\n--------------------------------------------\n", new Object[0]);
            return false;
        }
        return true;
    }

    private static boolean loadPluginByReflection() {
        try {
            System.loadLibrary(coreSoName);
        }
        catch (Throwable throwable) {
            UQMLog.d("loadPluginByReflection failed: " + throwable.getMessage(), new Object[0]);
            return false;
        }
        return true;
    }
}

